<?php
require_once 'config/api_config.php';

$apiKey = SMSPOOL_API_KEY;
$baseUrl = SMSPOOL_BASE_URL;

// Define test parameters
$params = [
    'key' => $apiKey,
    'action' => 'getSms',
    'userid' => 'test_user_id',  // Replace with a valid test user ID
];

$url = $baseUrl . '?' . http_build_query($params);

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

// Display the API response
header('Content-Type: application/json');
echo json_encode([
    'status' => $httpCode,
    'response' => json_decode($response, true)
]);
?>
