<?php
require_once '../services/sms_service.php';
require_once '../config/db.php';
session_start();

if (!isset($_SESSION['user_id'])) {
    header("Location: ../client/login.php");
    exit;
}

$smsMessages = fetchReceivedSMS($_SESSION['user_id']);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <title>Received SMS - SMS Rental</title>
    <link rel="stylesheet" href="../public/style.css">
</head>
<body>
    <div class="container">
        <h2>Received SMS</h2>

        <?php if (isset($_SESSION['error'])): ?>
            <div class="alert alert-danger"><?= $_SESSION['error']; unset($_SESSION['error']); ?></div>
        <?php endif; ?>

        <table class="table">
            <thead>
                <tr>
                    <th>Sender</th>
                    <th>Message</th>
                    <th>Received At</th>
                </tr>
            </thead>
            <tbody>
                <?php if (!empty($smsMessages) && isset($smsMessages['messages'])): ?>
                    <?php foreach ($smsMessages['messages'] as $sms): ?>
                        <tr>
                            <td><?= htmlspecialchars($sms['sender']); ?></td>
                            <td><?= htmlspecialchars($sms['message']); ?></td>
                            <td><?= htmlspecialchars($sms['date']); ?></td>
                        </tr>
                    <?php endforeach; ?>
                <?php else: ?>
                    <tr>
                        <td colspan="3">No SMS received yet.</td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>

        <a href="index.php" class="btn btn-secondary">Back to Dashboard</a>
    </div>
</body>
</html>
