<?php
require '../config/db.php';
session_start();

if (!isset($_SESSION['user_id'])) {
    exit;
}

$user_id = $_SESSION['user_id'];

$stmt = $pdo->prepare("
    SELECT sms_messages.sender, sms_messages.message, sms_messages.received_at, rented_numbers.phone_number, rented_numbers.service_name
    FROM sms_messages
    JOIN rented_numbers ON sms_messages.rented_number_id = rented_numbers.id
    WHERE rented_numbers.user_id = ?
    ORDER BY sms_messages.received_at DESC
");
$stmt->execute([$user_id]);
$sms_messages = $stmt->fetchAll(PDO::FETCH_ASSOC);

foreach ($sms_messages as $sms) {
    echo "<tr>
        <td>" . htmlspecialchars($sms['phone_number']) . "</td>
        <td>" . htmlspecialchars($sms['service_name']) . "</td>
        <td>" . htmlspecialchars($sms['sender']) . "</td>
        <td>" . htmlspecialchars($sms['message']) . "</td>
        <td>" . htmlspecialchars($sms['received_at']) . "</td>
    </tr>";
}
?>
