<?php
require_once __DIR__ . '/../config/api_config.php';

$apiUrl = "https://api.smspool.net/country/retrieve_all";
$serviceId = 1;  // Change this to the actual service ID

// Initialize cURL
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $apiUrl);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, ['service' => $serviceId]); // Sending form data

// Execute the request
$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

// Decode response
$responseData = json_decode($response, true);

// Display the response
header('Content-Type: application/json');
echo json_encode([
    'status' => $httpCode,
    'response' => $responseData
]);
?>
