<?php
require_once 'config/db.php';
session_start();

if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit;
}

$service_id = $_POST['service_id'] ?? null;
$country = $_POST['country'] ?? null;
$price = $_POST['price'] ?? null;

if (!$service_id || !$country || !$price) {
    $_SESSION['error'] = "Invalid request.";
    header("Location: index.php");
    exit;
}

// Check user balance again
$user_id = $_SESSION['user_id'];
$stmt = $pdo->prepare("SELECT wallet_balance FROM users WHERE id = ?");
$stmt->execute([$user_id]);
$user = $stmt->fetch(PDO::FETCH_ASSOC);

if ($user['wallet_balance'] < $price) {
    $_SESSION['error'] = "Insufficient balance.";
    header("Location: wallet.php");
    exit;
}

// Deduct balance
$new_balance = $user['wallet_balance'] - $price;
$stmt = $pdo->prepare("UPDATE users SET wallet_balance = ? WHERE id = ?");
$stmt->execute([$new_balance, $user_id]);

// Call API to rent number
$api_url = "https://api.smspool.net/request/rent_number";
$api_key = getenv('API_KEY');

$curl = curl_init();
curl_setopt_array($curl, [
    CURLOPT_URL => $api_url,
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_POST => true,
    CURLOPT_POSTFIELDS => json_encode([
        "service" => $service_id,
        "country" => $country
    ]),
    CURLOPT_HTTPHEADER => [
        "Authorization: Bearer $api_key",
        "Content-Type: application/json"
    ],
]);

$response = curl_exec($curl);
curl_close($curl);

$_SESSION['success'] = "Number rented successfully!";
header("Location: transactions.php");
exit;
