<?php
require '../config/db.php';
session_start();

if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit;
}

$user_id = $_SESSION['user_id'];

// Fetch received messages for the user
$stmt = $pdo->prepare("
    SELECT sms_messages.sender, sms_messages.message, sms_messages.received_at, rented_numbers.phone_number, rented_numbers.service_name
    FROM sms_messages
    JOIN rented_numbers ON sms_messages.rented_number_id = rented_numbers.id
    WHERE rented_numbers.user_id = ?
    ORDER BY sms_messages.received_at DESC
");
$stmt->execute([$user_id]);
$sms_messages = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <title>Received SMS - SMS Rental</title>
    <link rel="stylesheet" href="../public/bootstrap.min.css">
</head>
<body class="bg-light">
    <div class="container mt-5">
        <h2 class="text-center">Received SMS</h2>
        <table class="table table-bordered">
            <thead>
                <tr>
                    <th>Phone Number</th>
                    <th>Service</th>
                    <th>Sender</th>
                    <th>Message</th>
                    <th>Received At</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($sms_messages as $sms): ?>
                    <tr>
                        <td><?= htmlspecialchars($sms['phone_number']); ?></td>
                        <td><?= htmlspecialchars($sms['service_name']); ?></td>
                        <td><?= htmlspecialchars($sms['sender']); ?></td>
                        <td><?= htmlspecialchars($sms['message']); ?></td>
                        <td><?= htmlspecialchars($sms['received_at']); ?></td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
        <a href="dashboard.php" class="btn btn-secondary">Back to Dashboard</a>
    </div>
</body>
</html>
